/*
    This code is for RGB led Lantern.
    We have a bulb and 8 RGB led strips of 30 pixels
    which we would control by using the dabble app
    we have a bulb which is operated by relay on pin 10 of evive.
    All the LED strips are connected in parralel and on pin 2 of evive.
    Made by Satya Zaveri.
    On 16 october 2019.

  Explore more on: https://create.arduino.cc/projecthub/theSTEMpedia
*/
#include <evive.h>
#include <Dabble.h>
#include <Adafruit_NeoPixel.h>
Adafruit_NeoPixel Strip_1 = Adafruit_NeoPixel(30, 2, NEO_GRB + NEO_KHZ800);
void setup() 
{
Dabble.begin(115200);
pinMode(10, OUTPUT);
Strip_1.begin();
 Strip_1.show();
digitalWrite(10, true);
}
void loop() 
{
Dabble.processInput();
if(Terminal.compareString("on")) {
digitalWrite(10, false);
}
if(Terminal.compareString("off")) {
digitalWrite(10, true);
}
if(Terminal.compareString("red")) {
colorWipe(Strip_1.Color(244, 0, 0), 0.01*1000);
}
if(Terminal.compareString("green")) {
colorWipe(Strip_1.Color(16, 244, 0), 0.01*1000);
}
if(Terminal.compareString("yellow")) {
colorWipe(Strip_1.Color(240, 244, 0), 0.01*1000);
}
if(Terminal.compareString("blue")) {
colorWipe(Strip_1.Color(0, 8, 244), 0.01*1000);
}
if(Terminal.compareString("rainbow")) {
theaterChaseRainbow(0.05*1000);
}
}
void colorWipe(uint32_t color, int wait) {
  for(int i=0; i<Strip_1.numPixels(); i++) { // For each pixel in strip...
    Strip_1.setPixelColor(i, color);         //  Set pixel's color (in RAM)
    Strip_1.show();                          //  Update strip to match
    delay(wait);                           //  Pause for a moment
  }
}
void theaterChaseRainbow(int wait) {
  int firstPixelHue = 0;     // First pixel starts at red (hue 0)
  for (int a = 0; a < 30; a++) { // Repeat 30 times...
    for (int b = 0; b < 3; b++) { //  'b' counts from 0 to 2...
      Strip_1.clear();         //   Set all pixels in RAM to 0 (off)
      // 'c' counts up from 'b' to end of Strip_1 in increments of 3...
      for (int c = b; c < Strip_1.numPixels(); c += 3) {
        // hue of pixel 'c' is offset by an amount to make one full
        // revolution of the color wheel (range 65536) along the length
        // of the Strip_1 (Strip_1.numPixels() steps):
        int      hue   = firstPixelHue + c * 65536L / Strip_1.numPixels();
        uint32_t color = Strip_1.gamma32(Strip_1.ColorHSV(hue)); // hue -> RGB
        Strip_1.setPixelColor(c, color); // Set pixel 'c' to value 'color'
      }
      Strip_1.show();                // Update Strip_1 with new contents
      delay(wait);                 // Pause for a moment
      firstPixelHue += 65536 / 90; // One cycle of color wheel over 90 frames
    }
  }
}
