#include <Adafruit_NeoPixel.h>
#include<evive.h>

#define neo_pixel_pin 2
#define number_of_neo_pixel 48
#define piezo 46
#define dimmer 30

long freqIn;
long blow1;
long blow2;

unsigned int last_num =0;
int brightness = 128;

Adafruit_NeoPixel strip = Adafruit_NeoPixel(number_of_neo_pixel,neo_pixel_pin, NEO_GRB + NEO_KHZ800);

uint32_t red_color = strip.Color(150,0,0);
uint32_t blue_color = strip.Color(0,0,150);
uint32_t green_color = strip.Color(0,150,0);
uint32_t white_color = strip.Color(150,150,150);
uint32_t dim_red_color = strip.Color(dimmer,0,0);
uint32_t dim_blue_color = strip.Color(0,0,dimmer);
uint32_t dim_green_color = strip.Color(0,dimmer,0);
uint32_t dim_white_color = strip.Color(dimmer,dimmer,dimmer);


void setup() 
   {
      // put your setup code here, to run once:
      Serial.begin(9600);
  
      pinMode(piezo,OUTPUT);
      pinMode(neo_pixel_pin,OUTPUT);
      strip.begin();
      strip.setBrightness(brightness);
      strip.show();

      randomSeed(analogRead(A0));

      tft_init(INITR_GREENTAB);
      tft.setRotation(1);
      tft.fillScreen(ST7735_BLACK);

       tft.setCursor(25,10);
       tft.setTextSize(2);
       tft.setTextColor(ST7735_WHITE,ST7735_BLACK);
       tft.print("STEMpedia");

       tft.setCursor(35,50);
       tft.setTextSize(1.8);
       tft.setTextColor(ST7735_GREEN,ST7735_BLACK);
       tft.print("DIY E-CRACKER ");
     

        tft.setTextColor(ST7735_GREEN,ST7735_BLACK);
        tft.setCursor(1,95);
        tft.setTextSize(1.8);
        tft.print("FOR MORE INFORMATION VISIT");
        tft.setCursor(30,110);
        tft.setTextColor(ST7735_WHITE,ST7735_BLACK);
        tft.print("thestempedia.com");

   }

void loop()
    {
       // put your main code here, to run repeatedly:

       while(digitalRead(40)==HIGH)
          {
            launch();
            Clear();
            for(unsigned int i=0;i<6;i++)
              {
                flam();
              }
           Clear();
           unsigned int num = random(0,8);
           while(last_num ==num)
               {
                  num=random(0,8);
               }
          if(num==0)
              {
                last_num = 0;
                explosion(red_color,dim_red_color);  
              }
          else if(num == 1)
             {
                last_num = 1;
                explosion(blue_color,dim_blue_color);  
             }
          else if(num == 2)
             { 
               last_num = 2;
               explosion(green_color,dim_green_color);
             }
         else if(num == 3)
            {
               last_num = 3;
               explosion(white_color,dim_white_color);
            }
         else if(num==4)
            {
               last_num=4;
               random_explosion(red_color); 
            }
         else if(num == 5)
           { 
               last_num=5;
               random_explosion(blue_color);   
           }
         else if(num == 6)
          {
              last_num=6;
              random_explosion(green_color);
          }
        else if(num == 7)
          {
             last_num=7;
             random_explosion(white_color);
          }
        Clear();
     }
  }

void piezoTone(long freq, long duration)
    {
       long aSecond = 1000000;
       long period = aSecond/freq;
       duration = duration*1000;
       duration = duration/period;
       for(long k = 0; k < duration; k++)
          {
             digitalWrite(piezo,HIGH);
             delayMicroseconds(period/2);
             digitalWrite(piezo,LOW);
             delayMicroseconds(period/2);
          }
    } 
    
 void explosion(uint32_t color,uint32_t dim)
   {
      unsigned int x =0;
      unsigned int i=35;
      for(int k = 0; k < 300; k++)
        {
          x++;
          if(x==20)
            {
              if(i>39)
                {
                  strip.setPixelColor(i,color);
                  strip.setPixelColor(i-5,strip.Color(0,0,0));
                  strip.setPixelColor(i-4,dim);
                  strip.setPixelColor(i-3,dim);
                  strip.setPixelColor(i-2,dim);
                  strip.setPixelColor(i-1,dim);
                  strip.show();
                } 
             else if(i<=39)
            {
              strip.setPixelColor(i,color);
              strip.show();
            }
            x=0;
            i++;
           }
          blow1 = random(500,1000);
          blow2 = random(1,5);
          piezoTone(blow1,blow2);
     }  
  }

void launch()
{
   int x=0;
   int i=0;
   for(freqIn = 200; freqIn < 500; freqIn = freqIn + 2)
      {
         i++;
         if(i==6)
           {
             if(x>2)
                 {
                    strip.setPixelColor(x-3,strip.Color(0,0,0));
                    strip.setPixelColor(x-2,strip.Color(80,0,0));
                    strip.setPixelColor(x-1,strip.Color(80,0,0));
                    strip.setPixelColor(x,strip.Color(150,0,0));
                    strip.show();
                 }
            else if(x<=2)
                 {
                   strip.setPixelColor(x,strip.Color(100,0,0));
                   strip.show();
                 }
                   x++;
                   i=0;
           }
        piezoTone(1000000/freqIn,10);
     }
}

//void explosion (uint32_t color)
//  {
//    unsigned int x =0;
//    unsigned int i=0;
//  for(int k = 0; k < 300; k++)
//     {
//          x++;
//          if(x==20)
//          {
//            i++;
//            strip.setPixelColor(34+i,color);
//            strip.show();
//            x=0;
//          }
//          blow1 = random(500,1000);
//          blow2 = random(1,5);
//          piezoTone(blow1,blow2);
//     }  
//  }

 void flam()
    {
       //  Regular (orange) flame:
       int r = 226, g = 100, b = 15;

       //  Flicker, based on our initial RGB values
      for(int i=25; i<35; i++)
        {
          int flicker = random(0,55);
          int r1 = r-flicker;
          int g1 = g-flicker;
          int b1 = b-flicker;
          if(g1<0) g1=0;
          if(r1<0) r1=0;
          if(b1<0) b1=0;
          strip.setPixelColor(i,r1,g1, b1);
        }
       strip.show();

     //  Adjust the delay here, if you'd like.  Right now, it randomizes the 
     //  color switch delay to give a sense of realism
     delay(random(10,20));
  }

  void Clear()
  {
    for(unsigned int i=0;i<48;i++)
         {
            strip.setPixelColor(i,strip.Color(0,0,0));  
         }
    strip.show();
  }

  void random_explosion(uint32_t color)
     {
        unsigned int num1=0;
        unsigned int last_num1=0;
        unsigned int p=0;
        for(int k = 0; k < 300; k++)
           {    
              p++;
              if(p>=3)
                 {
                    num1 = random(25,48);
                    while(num1==last_num1)
                      {
                          num1=random(25,48);
                      }
                   strip.setPixelColor(num1,color);
                   strip.setPixelColor(last_num1,strip.Color(0,0,0));
                   strip.show();
                   p=0;
                   last_num1 =num1;
                }
             blow1 = random(500,1000);
             blow2 = random(1,5);
             piezoTone(blow1,blow2);
          }    
  }

